package h23.numberplace;

public class Board {
	private int board[][] = new int[9][9];
	private boolean enableChange[][] = new boolean[9][9];
	private int answer[][] = new int[9][9];

	public Board(){
		boardInit();
	}

	public void boardInit(){
		for(int i=0;i<9;i++){
			for(int j=0;j<9;j++){
				board[i][j] = 0;
				answer[i][j] = 10;
				enableChange[i][j] = true;
			}
		}
	}

	public void setBoard(int board[][]){
		for(int i=0;i<9;i++){
			for(int j=0;j<9;j++){
				this.board[i][j] = board[i][j];
				if(board[i][j] == 0){
					enableChange[i][j] = true;
				}else{
					enableChange[i][j] = false;
				}
			}
		}
	}

	public void setEnableChange(int x, int y, boolean enable){
		enableChange[x][y] = enable;
	}

	public void setAnswer(int answer[][]){
		for(int i=0;i<9;i++){
			for(int j=0;j<9;j++){
				this.answer[i][j] = answer[i][j];
			}
		}
	}

	public void setEnableChange(boolean enable[][]){
		for(int i=0;i<9;i++){
			for(int j=0;j<9;j++){
				this.enableChange[i][j] = enable[i][j];
			}
		}
	}

	public int[][] getBoard(){
		return board;
	}

	public int[][] getAnswer(){
		return answer;
	}

	public boolean[][] getEnable(){
		return enableChange;
	}

	public boolean getEnableChange(int x, int y){
		return enableChange[x][y];
	}


	public void changeBoard(int x, int y, int num){
		if((x < 0) || (8 < x) || (y < 0) || (8 < y)){
			return;
		}

		if(enableChange[x][y]){
			board[x][y] = num;
		}
	}

	public boolean isCorrect(){
		for(int i=0;i<9;i++){
			for(int j=0;j<9;j++){
				if(board[i][j] != answer[i][j]){
					return false;
				}
			}
		}

		return true;
	}

}
